/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedHashSet;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.source.FileRegistry;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Pair;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public abstract class LocationAction
extends AbstractAction
implements ContextAwareAction {
    private Lookup context;
    private final L list = new L();
    private final FileRegistry registry;
    private Lookup.Result nbNodeResult;
    private Lookup.Result inputNodeResult;
    private Icon smallIcon;

    protected LocationAction() {
        this(Utilities.actionsGlobalContext());
    }

    protected LocationAction(String name) {
        this(name, Utilities.actionsGlobalContext());
    }

    protected LocationAction(String name, Icon icon) {
        this(name, icon, Utilities.actionsGlobalContext());
    }

    protected LocationAction(Lookup context) {
        this.context = context;
        this.registry = FileRegistry.getInstance();
        this.init();
    }

    protected LocationAction(String name, Lookup context) {
        super(name);
        this.context = context;
        this.registry = FileRegistry.getInstance();
        this.init();
    }

    protected LocationAction(String name, Icon icon, Lookup context) {
        super(name, icon);
        this.context = context;
        this.registry = FileRegistry.getInstance();
    }

    private void init() {
        if (this.context != null) {
            this.nbNodeResult = this.context.lookupResult(Node.class);
            this.inputNodeResult = this.context.lookupResult(InputNode.class);
            this.nbNodeResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.list, (Object)this.nbNodeResult));
            this.inputNodeResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.list, (Object)this.inputNodeResult));
        }
        this.registry.addFileRegistryListener((FileRegistry.FileRegistryListener)WeakListeners.create(FileRegistry.FileRegistryListener.class, (EventListener)this.list, (Object)this.registry));
    }

    protected final Lookup context() {
        return this.context == null ? Lookup.EMPTY : this.context;
    }

    protected final Node[] activeNodes() {
        Collection nbNodes = this.nbNodeResult.allInstances();
        return nbNodes.toArray(new Node[nbNodes.size()]);
    }

    private Pair<InputGraph, InputNode[]> data() {
        LinkedHashSet<InputNode> gNodes = this.inputNodeResult.allInstances();
        InputGraph g = null;
        if (!gNodes.isEmpty()) {
            g = (InputGraph)this.context.lookup(InputGraph.class);
        } else {
            Collection nbNodes = this.nbNodeResult.allInstances();
            if (nbNodes.isEmpty()) {
                return null;
            }
            for (Node n : nbNodes) {
                InputNode in = (InputNode)n.getLookup().lookup(InputNode.class);
                if (in == null) continue;
                if (gNodes.isEmpty()) {
                    gNodes = new LinkedHashSet<InputNode>();
                }
                InputGraph ig = (InputGraph)n.getLookup().lookup(InputGraph.class);
                if (g != null && ig != g && !this.acceptDifferentGraphs()) {
                    return null;
                }
                if (g == null) {
                    g = ig;
                }
                gNodes.add(in);
            }
        }
        return Pair.of((Object)g, (Object)gNodes.toArray(new InputNode[gNodes.size()]));
    }

    private void refreshEnabled() {
        Collection gNodes = this.inputNodeResult.allInstances();
        Pair<InputGraph, InputNode[]> p = this.data();
        this.setEnabled(p != null && this.computeEnabled((InputGraph)p.first(), (InputNode[])p.second()));
    }

    protected boolean acceptDifferentGraphs() {
        return false;
    }

    protected boolean computeEnabled(InputGraph graph, InputNode[] nodes) {
        return nodes.length > 0;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        Pair<InputGraph, InputNode[]> data;
        Container container;
        Object source;
        if (this.context == null && (source = e.getSource()) instanceof Component && (container = SwingUtilities.getAncestorOfClass(Lookup.Provider.class, (Component)source)) != null && container instanceof Lookup.Provider) {
            this.context = ((Lookup.Provider)container).getLookup();
        }
        if ((data = this.data()) == null || !this.computeEnabled((InputGraph)data.first(), (InputNode[])data.second())) {
            this.setEnabled(false);
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.actionPerformed(e, (InputGraph)data.first(), (InputNode[])data.second());
        }
    }

    protected abstract void actionPerformed(ActionEvent var1, InputGraph var2, InputNode[] var3);

    private Icon getIcon() {
        if (this.smallIcon != null) {
            return this.smallIcon;
        }
        String r = this.iconResource();
        if (r == null) {
            return null;
        }
        this.smallIcon = ImageUtilities.loadImageIcon((String)r, (boolean)true);
        return this.smallIcon;
    }

    protected String iconResource() {
        return null;
    }

    public String getKey() {
        return (String)super.getValue("Name");
    }

    public String getName() {
        return (String)super.getValue("Name");
    }

    @Override
    public Object getValue(String key) {
        switch (key) {
            case "SmallIcon": {
                return this.getIcon();
            }
            case "ShortDescription": {
                return this.getName();
            }
            case "Name": {
                return this.getName();
            }
        }
        return super.getValue(key);
    }

    class L
    implements LookupListener,
    FileRegistry.FileRegistryListener {
        L() {
        }

        public void resultChanged(LookupEvent ev) {
            LocationAction.this.refreshEnabled();
        }

        @Override
        public void filesResolved(FileRegistry.FileRegistryEvent ev) {
            LocationAction.this.refreshEnabled();
        }
    }
}

