/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import javax.swing.AbstractAction;
import org.graalvm.visualizer.source.impl.actions.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.actions.CallbackSystemAction;

public class RemoveSourceRootAction
extends CallbackSystemAction {
    public RemoveSourceRootAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void initialize() {
        super.initialize();
    }

    public Object getActionMapKey() {
        return "delete";
    }

    public String getName() {
        return Bundle.ACTION_RemoveSourceRoot();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RemoveSourceRootAction.class);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/delete.gif";
    }

    protected boolean asynchronous() {
        return true;
    }

    public static class Perfomer
    extends AbstractAction
    implements Runnable {
        private boolean confirmDelete;
        private final ExplorerManager manager;

        public Perfomer(ExplorerManager manager, boolean confirmDelete) {
            this.confirmDelete = confirmDelete;
            this.manager = manager;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            ExplorerManager em = this.manager;
            if (em == null) {
                return;
            }
            Node[] sel = em.getSelectedNodes();
            if (sel == null || sel.length == 0) {
                return;
            }
            if (!this.confirmDelete || this.doConfirm(sel)) {
                try {
                    em.setSelectedNodes(new Node[0]);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.doDestroy(sel);
                Mutex.EVENT.readAccess((Runnable)this);
            }
        }

        @Override
        public void run() {
            assert (EventQueue.isDispatchThread());
            this.setEnabled(false);
        }

        private boolean doConfirm(Node[] sel) {
            String title;
            String message;
            boolean customDelete = true;
            for (int i = 0; i < sel.length; ++i) {
                if (Boolean.TRUE.equals(sel[i].getValue("customDelete"))) continue;
                customDelete = false;
                break;
            }
            if (customDelete) {
                return true;
            }
            if (sel.length == 1) {
                message = Bundle.MSG_ConfirmRemoveObject(sel[0].getDisplayName());
                title = Bundle.MSG_ConfirmRemoveObjectTitle();
            } else {
                message = Bundle.MSG_ConfirmRemoveObjects(sel.length);
                title = Bundle.MSG_ConfirmRemoveObjectsTitle();
            }
            NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)message, title, 0);
            return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc));
        }

        private void doDestroy(Node[] sel) {
            for (int i = 0; i < sel.length; ++i) {
                try {
                    sel[i].destroy();
                    continue;
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }
    }
}

