/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.source.NodeLocationContext;
import org.graalvm.visualizer.source.NodeLocationEvent;
import org.graalvm.visualizer.source.NodeLocationListener;
import org.graalvm.visualizer.source.NodeStack;
import org.graalvm.visualizer.source.impl.actions.Bundle;
import org.netbeans.api.actions.Viewable;
import org.openide.awt.Actions;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class SourceViewAction
extends AbstractAction
implements NodeLocationListener,
ContextAwareAction,
Presenter.Toolbar {
    public static final String ID = "org.graalvm.visualizer.source.impl.actions.SourceViewAction";
    final NodeLocationContext context;
    final TopComponent myEditor;

    public SourceViewAction() {
        this((TopComponent)null);
    }

    public SourceViewAction(TopComponent ed) {
        this.putValue("SmallIcon", new ImageIcon(ImageUtilities.loadImage((String)this.iconResource())));
        this.putValue("SwingSelectedKey", false);
        this.putValue("ShortDescription", Bundle.DESC_SourceViewSync());
        this.context = (NodeLocationContext)Lookup.getDefault().lookup(NodeLocationContext.class);
        if (this.context != null) {
            this.context.addNodeLocationListener((NodeLocationListener)WeakListeners.create(NodeLocationListener.class, (EventListener)this, (Object)this.context));
        }
        this.myEditor = ed;
    }

    public boolean isSelected() {
        return (Boolean)this.getValue("SwingSelectedKey");
    }

    public void setSelected(boolean b) {
        if (this.isSelected() != b) {
            this.putValue("SwingSelectedKey", b);
        }
    }

    protected String iconResource() {
        return "org/graalvm/visualizer/view/images/followSource.png";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setSelected(!this.isSelected());
        this.nodesChanged(null);
    }

    @Override
    public void nodesChanged(NodeLocationEvent evt) {
        Collection<InputNode> nodes;
        if (!this.isSelected() || this.context == null || WindowManager.getDefault().getRegistry().getActivated() != this.myEditor) {
            return;
        }
        Collection<InputNode> collection = nodes = evt == null ? this.context.getGraphNodes() : evt.getNodes();
        if (nodes.isEmpty()) {
            return;
        }
        InputNode n = nodes.iterator().next();
        this.viewSelectedNodeSource(n);
    }

    private void viewSelectedNodeSource(InputNode n) {
        if (!this.isSelected()) {
            return;
        }
        NodeStack locs = this.context.getStack(n);
        if (locs == null || locs.isEmpty()) {
            return;
        }
        NodeStack.Frame loc = locs.top();
        this.context.setSelectedLocation(loc);
        Viewable v = (Viewable)loc.getLookup().lookup(Viewable.class);
        if (v != null) {
            v.view();
        }
    }

    @Override
    public void locationsResolved(NodeLocationEvent evt) {
    }

    @Override
    public void selectedLocationChanged(NodeLocationEvent evt) {
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        TopComponent tc = (TopComponent)actionContext.lookup(TopComponent.class);
        if (tc != null) {
            return new SourceViewAction(tc);
        }
        return null;
    }

    @Override
    public void selectedNodeChanged(NodeLocationEvent evt) {
        InputNode selNode = evt.getSelectedNode();
        if (!this.isSelected() || selNode == null) {
            return;
        }
        if (TopComponent.getRegistry().getActivated() != this.myEditor) {
            return;
        }
        this.viewSelectedNodeSource(selNode);
    }

    public Component getToolbarPresenter() {
        JToggleButton b = new JToggleButton();
        Actions.connect((AbstractButton)b, (Action)this);
        return b;
    }
}

