/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.editor;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.function.Consumer;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.data.services.GraphSelections;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.NodeLocationContext;
import org.graalvm.visualizer.source.SourceUtils;
import org.graalvm.visualizer.source.impl.editor.Bundle;
import org.graalvm.visualizer.source.impl.editor.TrackNodesAction;
import org.graalvm.visualizer.util.LookupHistory;
import org.graalvm.visualizer.view.api.DiagramViewer;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseAction;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public abstract class SelectOrExtractNodesAction
extends BaseAction
implements ContextAwareAction {
    public static final String NAME_EXTRACT = "graph-extract-nodes";
    private final boolean selection;
    private final JEditorPane pane;
    static final RequestProcessor DELAY_RP = new RequestProcessor(TrackNodesAction.class);
    private static final int DELAY = 500;
    private boolean pendingRefresh;
    private Tracker tracker;

    SelectOrExtractNodesAction(boolean selection, String name) {
        this(selection, name, Lookup.EMPTY);
    }

    SelectOrExtractNodesAction(boolean selection, String name, Lookup lkp) {
        super(name);
        this.selection = selection;
        this.pane = (JEditorPane)lkp.lookup(JEditorPane.class);
        if (this.pane != null) {
            this.tracker = new Tracker();
            this.pane.addCaretListener(this.tracker);
        } else {
            this.tracker = null;
        }
    }

    protected boolean asynchonous() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cancelRefresh() {
        SelectOrExtractNodesAction selectOrExtractNodesAction = this;
        synchronized (selectOrExtractNodesAction) {
            if (this.pendingRefresh) {
                this.tracker.task.cancel();
                return true;
            }
        }
        return false;
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        boolean shiftPressed = (evt.getModifiers() & 1) > 0;
        FileObject fo = EditorDocumentUtils.getFileObject((Document)target.getDocument());
        NodeLocationContext context = (NodeLocationContext)Lookup.getDefault().lookup(NodeLocationContext.class);
        Collection<InputNode> nodes = null;
        if (context != null && fo != null) {
            Caret c = target.getCaret();
            int p1 = c.getDot();
            int p2 = c.getMark();
            LineDocument ld = (LineDocument)LineDocumentUtils.as((Document)target.getDocument(), LineDocument.class);
            if (ld != null) {
                int n2;
                int n1;
                try {
                    n1 = LineDocumentUtils.getLineIndex((LineDocument)ld, (int)p1);
                    n2 = LineDocumentUtils.getLineIndex((LineDocument)ld, (int)p2);
                }
                catch (BadLocationException ex) {
                    return;
                }
                int from = Math.min(n1, n2) + 1;
                int to = Math.max(n1, n2) + 1;
                nodes = SourceUtils.findLineNodes(fo, from, to, null, null, true);
            } else {
                nodes = SelectOrExtractNodesAction.findLineNodes(target, null);
            }
        }
        if (nodes == null) {
            Toolkit.getDefaultToolkit().beep();
            StatusDisplayer.getDefault().setStatusText(Bundle.ERR_NoLocationsInFile(fo.getNameExt()));
            return;
        }
        InputGraph graph = context.getGraph();
        context.setGraphContext(graph, nodes);
        GraphSelections sel = (GraphSelections)LookupHistory.getLast(GraphSelections.class);
        DiagramViewer viewer = (DiagramViewer)LookupHistory.getLast(DiagramViewer.class);
        Collection<InputNode> fNodes = nodes;
        viewer.getModel().withDiagramToView(dg -> SwingUtilities.invokeLater(() -> {
            if (this.selection) {
                SelectOrExtractNodesAction.selectFirstOrNext(dg, viewer, fNodes, shiftPressed, false, ns -> viewer.getSelections().setSelectedNodes(ns));
            } else {
                sel.extractNodes(fNodes);
            }
        }));
    }

    protected void refreshUI() {
    }

    static void selectFirstOrNext(Diagram dg, DiagramViewer view, Collection<InputNode> nodes, boolean all, boolean doNothingIfFound, Consumer<Collection<InputNode>> consumer) {
        if (all) {
            consumer.accept(SourceUtils.findTopNodes(view, nodes));
        } else {
            Collection<InputNode> sel = SourceUtils.selectNext(dg, view, nodes, doNothingIfFound);
            if (sel != null) {
                consumer.accept(sel);
            }
        }
    }

    protected static Collection<InputNode> findLineNodes(JTextComponent target, Collection<Location> outLocs) {
        return SourceUtils.findLineNodes(target, null, outLocs, true);
    }

    private class Tracker
    implements CaretListener,
    Runnable {
        RequestProcessor.Task task;

        private Tracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void caretUpdate(CaretEvent e) {
            Tracker tracker = this;
            synchronized (tracker) {
                if (this.task != null) {
                    this.task.cancel();
                }
                SelectOrExtractNodesAction.this.pendingRefresh = true;
                this.task = DELAY_RP.post((Runnable)this, 500);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                SelectOrExtractNodesAction.this.pendingRefresh = false;
                SelectOrExtractNodesAction.this.refreshUI();
            } else {
                Tracker tracker = this;
                synchronized (tracker) {
                    this.task = null;
                }
                SwingUtilities.invokeLater(this);
            }
        }
    }
}

