/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.graalvm.visualizer.settings.graal.GraalSettings;
import org.graalvm.visualizer.view.ExportCookie;

public final class ExportAction
implements ActionListener {
    public static final String ID = "org.graalvm.visualizer.view.actions.ExportAction";
    private final ExportCookie cake;

    public ExportAction(ExportCookie cake) {
        this.cake = cake;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GraalSettings settings = GraalSettings.obtain();
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return true;
            }

            @Override
            public String getDescription() {
                return "SVG files (*.svg)";
            }
        });
        fc.setCurrentDirectory(new File(settings.getDirectory()));
        if (fc.showSaveDialog(null) == 0) {
            File dir;
            File file = fc.getSelectedFile();
            if (!file.getName().contains(".")) {
                file = new File(file.getAbsolutePath() + ".svg");
            }
            if (!(dir = file).isDirectory()) {
                dir = dir.getParentFile();
            }
            settings.setDirectory(dir.getAbsolutePath());
            this.cake.export(file);
        }
    }
}

