/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filterwindow.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.FilterCanceledException;
import org.graalvm.visualizer.filter.FilterEvent;
import org.graalvm.visualizer.filter.FilterExecution;
import org.graalvm.visualizer.filter.FilterExecutionService;
import org.graalvm.visualizer.filter.FilterListener;
import org.graalvm.visualizer.filter.FilterSequence;
import org.graalvm.visualizer.filter.profiles.FilterProfile;
import org.graalvm.visualizer.filter.profiles.FilterRegistry;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileService;
import org.graalvm.visualizer.filterwindow.CheckNode;
import org.graalvm.visualizer.filterwindow.impl.Bundle;
import org.graalvm.visualizer.util.ListenerSupport;
import org.graalvm.visualizer.util.PropertiesSheet;
import org.openide.actions.OpenAction;
import org.openide.awt.Actions;
import org.openide.cookies.OpenCookie;
import org.openide.nodes.Children;
import org.openide.nodes.Sheet;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public final class FilterNode
extends CheckNode
implements FilterListener {
    private static final String ACTIONS = "IGV/Actions/Filter";
    private static final String ICON_NORMAL = "org/graalvm/visualizer/filterwindow/images/filterIcon.png";
    private static final String ICON_ERROR = "org/graalvm/visualizer/filterwindow/images/filterIconError.png";
    private final ProfileService service;
    private final Filter filter;
    private final FilterProfile profile;
    private final boolean defaultProfile;
    private Map<String, Throwable> reportedErrors = new LinkedHashMap<String, Throwable>();
    private FilterListener weakL;
    private final ChangedListener<Filter> changedL = new ChangedListener<Filter>(){

        public void changed(Filter source) {
            SwingUtilities.invokeLater(() -> FilterNode.this.update());
        }
    };

    public FilterNode(Filter filter, FilterProfile profile, ProfileService service) {
        this(filter, profile, service, new InstanceContent());
    }

    private FilterNode(Filter filter, FilterProfile profile, ProfileService service, InstanceContent content) {
        super(Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)content)}));
        this.filter = filter;
        this.profile = profile;
        this.service = service;
        boolean bl = this.defaultProfile = ((FilterRegistry)Lookup.getDefault().lookup(FilterRegistry.class)).getDefaultProfile() == profile;
        if (this.defaultProfile) {
            this.setShortDescription(Bundle.TOOLTIP_FilterClickEdit());
        }
        content.add((Object)filter);
        OpenCookie oc = (OpenCookie)filter.getLookup().lookup(OpenCookie.class);
        if (oc == null) {
            oc = filter.getEditor();
        }
        if (oc != null) {
            content.add((Object)oc);
        }
        filter.getChangedEvent().addListener((Object)new ChangedListener<Filter>(){

            public void changed(Filter source) {
                FilterNode.this.update();
            }
        });
        if (profile != null) {
            profile.getSelectedFilters().getChangedEvent().addListener((Object)new ChangedListener<FilterSequence>(){

                public void changed(FilterSequence source) {
                    FilterNode.this.filterSequenceChanged();
                }
            });
        }
        ListenerSupport.addWeakListener(this.changedL, (ChangedEvent)filter.getChangedEvent());
        this.update();
        if (profile != null) {
            this.filterSequenceChanged();
        }
        FilterExecutionService srv = FilterExecution.getExecutionService();
        this.weakL = (FilterListener)WeakListeners.create(FilterListener.class, (EventListener)((Object)this), (Object)srv);
        srv.addFilterListener(this.weakL);
    }

    private void update() {
        Filter original = this.service.findDefaultFilter(this.filter);
        if (original != null && original != this.filter && !original.getName().equals(this.filter.getName())) {
            this.setDisplayName(Bundle.FMT_FilterLinkName(this.filter.getName(), original.getName()));
            this.setShortDescription(Bundle.FMT_FilterLinkTooltip(this.filter.getName(), original.getName()));
        } else {
            this.setDisplayName(this.filter.getName());
        }
        this.reportedErrors.clear();
        this.setIconBaseWithExtension(ICON_NORMAL);
    }

    public Filter getFilter() {
        return this.filter;
    }

    protected Sheet createSheet() {
        Sheet s = super.createSheet();
        PropertiesSheet.initializeSheet((Properties)this.getFilter().getProperties(), (Sheet)s);
        return s;
    }

    public Action[] getActions(boolean b) {
        return new Action[]{(Action)OpenAction.findObject(OpenAction.class, (boolean)true), this.context(Actions.forID((String)"Filters", (String)"org.graalvm.visualizer.filterwindow.actions.MoveDown")), this.context(Actions.forID((String)"Filters", (String)"org.graalvm.visualizer.filterwindow.actions.MoveUp")), this.context(Actions.forID((String)"Filters", (String)"org.graalvm.visualizer.filterwindow.actions.RenameFilterAction"))};
    }

    private Action context(Action orig) {
        if (!(orig instanceof ContextAwareAction)) {
            return orig;
        }
        return ((ContextAwareAction)orig).createContextAwareInstance(this.getLookup());
    }

    public Action getPreferredAction() {
        return ((OpenAction)OpenAction.get(OpenAction.class)).createContextAwareInstance(Utilities.actionsGlobalContext());
    }

    private void filterSequenceChanged() {
        if (this.profile == null) {
            return;
        }
        super.setSelected(this.profile.getSelectedFilters().getFilters().contains(this.filter));
    }

    public void filterStart(FilterEvent e) {
    }

    public void filterEnd(FilterEvent e) {
        Throwable err;
        if (e.getFilter() != this.filter) {
            Filter f = e.getFilter();
            if (f == null) {
                return;
            }
            Collection filters = f.getLookup().lookupAll(Filter.class);
            if (!filters.stream().anyMatch(t -> t == this.filter)) {
                return;
            }
        }
        if ((err = e.getExecutionError()) == null) {
            if (!this.reportedErrors.isEmpty()) {
                this.update();
            }
            return;
        }
        if (err instanceof FilterCanceledException) {
            return;
        }
        this.setIconBaseWithExtension(ICON_ERROR);
        String str = this.exceptionString(e.getExecutionError());
        if (this.reportedErrors.containsKey(str)) {
            return;
        }
        this.reportedErrors.put(str, e.getExecutionError());
        this.fireIconChange();
        InputOutput io = IOProvider.getDefault().getIO(Bundle.TITLE_FilterExecution(), false);
        PrintWriter pw = new PrintWriter((Writer)io.getErr()){

            @Override
            public void close() {
            }
        };
        io.select();
        pw.print(Bundle.MSG_ErrorExecutionFilter(e.getFilter().getName()));
        e.getExecutionError().printStackTrace(pw);
    }

    private String exceptionString(Throwable t) {
        StringBuilder sb = new StringBuilder();
        sb.append(t.getClass().getName()).append(":").append(t.toString()).append(";");
        for (StackTraceElement sel : t.getStackTrace()) {
            sb.append(sel.getFileName()).append(":").append(sel.getLineNumber()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void setSelected(boolean b) {
        super.setSelected(b);
        if (this.profile != null) {
            try {
                this.profile.setEnabled(this.filter, this.isSelected());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

