/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.java.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.graal.compiler.graphio.parsing.LocationStackFrame;
import jdk.graal.compiler.graphio.parsing.LocationStratum;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.source.FileKey;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.ProcessorContext;
import org.graalvm.visualizer.source.SpecificLocationInfo;
import org.graalvm.visualizer.source.java.impl.JavaLocationInfo;
import org.graalvm.visualizer.source.spi.StackProcessor;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class JavaStackProcessor2
implements StackProcessor {
    private static final String CLASS_EXTENSION_SUFFIX = ".class";
    private static final String JAVA_EXTENSION_SUFFIX = ".java";
    private static final Pattern FRAME_PATTERN = Pattern.compile("(?:at )?(.*)\\((.*):([0-9]+)\\)");
    private ProcessorContext ctx;
    private final Map<String, Object> resolveCache = new HashMap<String, Object>();
    private static final Object UNRESOLVED = "unresolved";
    private ClassPath proxySource;
    private ClassPath proxyCompile;

    public void attach(ProcessorContext ctx) {
        this.ctx = ctx;
        Set roots = GlobalPathRegistry.getDefault().getSourceRoots();
        this.proxySource = ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[roots.size()]));
        Set compilePaths = GlobalPathRegistry.getDefault().getPaths("classpath/compile");
        this.proxyCompile = ClassPathSupport.createProxyClassPath((ClassPath[])compilePaths.toArray(new ClassPath[compilePaths.size()]));
    }

    public List<Location> processStack(InputNode node) {
        Properties props = node.getProperties();
        String s = props.getString("nodeSourcePosition", null);
        if (s == null) {
            return null;
        }
        Object o = props.get("nodeSourcePosition", Object.class);
        LocationStackFrame sf = null;
        if (o instanceof LocationStackFrame) {
            sf = (LocationStackFrame)o;
        }
        return new T(node, s, sf).process();
    }

    private class T {
        private final InputNode node;
        private final String stackTrace;
        private final LocationStackFrame stackTop;
        private LocationStackFrame stackFrame;
        private final List<Location> result = new ArrayList<Location>();
        private String methodName;
        private String className;
        private String spec;
        private int lineno;
        private int depth;

        public T(InputNode node, String stackTrace, LocationStackFrame stackTop) {
            this.stackTrace = stackTrace;
            this.node = node;
            this.stackTop = stackTop;
            this.stackFrame = stackTop;
        }

        private void reset() {
            this.spec = null;
            this.methodName = null;
            this.className = null;
            this.lineno = -1;
        }

        private LocationStratum findStratum(LocationStackFrame se) {
            for (LocationStratum stratum : se.getStrata()) {
                if (!"Java".equals(stratum.language)) continue;
                return stratum;
            }
            return null;
        }

        private void addLineLocation(String frameString) {
            FileObject ownerRoot;
            URL ownerURL;
            Object resource;
            String javaSource;
            Object o;
            String filename;
            String methodSpec;
            Matcher m = null;
            if (this.stackFrame == null && !(m = FRAME_PATTERN.matcher(frameString)).find()) {
                return;
            }
            if (this.stackFrame != null) {
                methodSpec = this.stackFrame.getFullMethodName();
                LocationStratum stratum = this.findStratum(this.stackFrame);
                if (stratum == null) {
                    return;
                }
                filename = stratum.uri != null ? stratum.uri : stratum.file;
                this.lineno = stratum.line;
                if (filename == null) {
                    return;
                }
            } else {
                methodSpec = m.group(1);
                filename = m.group(2);
                String lineString = m.group(3);
                this.lineno = Integer.parseInt(lineString);
            }
            String basename = null;
            if (filename.endsWith(JavaStackProcessor2.JAVA_EXTENSION_SUFFIX)) {
                basename = filename.substring(0, filename.length() - 5);
            }
            this.spec = frameString.substring(3);
            int methodDot = methodSpec.lastIndexOf(46);
            if (methodDot == -1) {
                return;
            }
            String fqn = methodSpec.substring(0, methodDot);
            this.methodName = methodSpec.substring(methodDot + 1);
            this.className = fqn;
            int $Pos = fqn.indexOf(36);
            String outername = fqn;
            if ($Pos > 0) {
                outername = fqn.substring(0, $Pos);
            }
            int dotPos = outername.lastIndexOf(46);
            if (basename == null) {
                basename = dotPos > 0 ? outername.substring(dotPos + 1) : outername;
            }
            if ((o = JavaStackProcessor2.this.resolveCache.get(javaSource = (String)(resource = dotPos == -1 ? basename.replace('.', '/') : outername.substring(0, dotPos + 1).replace('.', '/') + basename) + JavaStackProcessor2.JAVA_EXTENSION_SUFFIX)) instanceof FileObject) {
                this.addResolvedLocation(javaSource, (FileObject)o);
                return;
            }
            if (o != null) {
                this.addResolvedLocation(javaSource, null);
                return;
            }
            FileObject src = JavaStackProcessor2.this.proxySource.findResource(javaSource);
            if (src != null) {
                this.addResolvedLocation(javaSource, src);
                return;
            }
            FileObject clazz = JavaStackProcessor2.this.proxyCompile.findResource((String)resource + JavaStackProcessor2.CLASS_EXTENSION_SUFFIX);
            if (clazz != null && (ownerURL = URLMapper.findURL((FileObject)(ownerRoot = JavaStackProcessor2.this.proxyCompile.findOwnerRoot(clazz)), (int)0)) != null) {
                SourceForBinaryQuery.Result2 res = SourceForBinaryQuery.findSourceRoots2((URL)ownerURL);
                JavaStackProcessor2.this.proxySource = ClassPathSupport.createClassPath((FileObject[])res.getRoots());
                src = JavaStackProcessor2.this.proxySource.findResource(javaSource);
                if (src != null) {
                    this.addResolvedLocation(javaSource, src);
                    return;
                }
            }
            this.addResolvedLocation(javaSource, null);
        }

        private void addResolvedLocation(String filename, FileObject source) {
            JavaStackProcessor2.this.resolveCache.putIfAbsent(filename, source == null ? UNRESOLVED : source);
            Location lastloc = null;
            JavaLocationInfo prevInfo = null;
            if (!this.result.isEmpty()) {
                lastloc = this.result.get(0);
                prevInfo = (JavaLocationInfo)lastloc.getSpecificInfo(JavaLocationInfo.class);
            }
            JavaLocationInfo javaInfo = new JavaLocationInfo(-1, this.className, this.methodName, null);
            if (prevInfo != null) {
                javaInfo.callToMethod(prevInfo.getClassName(), prevInfo.getMethodName());
            } else {
                int dot;
                String fieldRef = this.node.getProperties().getString("field", null);
                String methodRef = this.node.getProperties().getString("targetMethod", null);
                if (fieldRef != null) {
                    int dot2 = fieldRef.lastIndexOf(46);
                    if (dot2 != -1) {
                        javaInfo.referToField(fieldRef.substring(0, dot2), fieldRef.substring(dot2 + 1));
                    }
                } else if (methodRef != null && (dot = methodRef.lastIndexOf(46)) != -1) {
                    javaInfo.callToMethod(methodRef.substring(0, dot), methodRef.substring(dot + 1));
                }
            }
            FileKey fk = JavaStackProcessor2.this.ctx.file(filename, source);
            Location newLoc = new Location(this.spec, fk, this.lineno, -1, -1, lastloc, this.depth, -1);
            JavaStackProcessor2.this.ctx.attachInfo(newLoc, (SpecificLocationInfo)javaInfo);
            javaInfo.withLocation(newLoc);
            this.result.add(newLoc);
        }

        public List<Location> process() {
            String[] lines = this.stackTrace.split("\n");
            int i = 0;
            while (this.stackFrame != null || i < lines.length) {
                this.addLineLocation(lines[i]);
                if (this.stackFrame != null) {
                    this.stackFrame = this.stackFrame.getParent();
                }
                ++i;
                ++this.depth;
                this.reset();
            }
            return this.result;
        }
    }

    public static final class Factory
    implements StackProcessor.Factory {
        public String[] getLanguageIDs() {
            return new String[]{"text/x-java"};
        }

        public StackProcessor createProcessor(ProcessorContext ctx) {
            return new JavaStackProcessor2();
        }
    }
}

