/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.problems;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.actions.Savable;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;

public class PropertiesEditor {
    private static final Logger LOG = Logger.getLogger(PropertiesEditor.class.getName());
    private FileObject file;
    private final Path filePath;
    private Document openedDocument;
    private EditableProperties properties;

    public PropertiesEditor(FileObject file) {
        this.file = file;
        File f = FileUtil.toFile((FileObject)file);
        this.filePath = f != null ? f.toPath() : null;
    }

    public PropertiesEditor(Path path) {
        this.filePath = path;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public EditableProperties open() throws IOException {
        if (this.properties != null) {
            return this.properties;
        }
        if (this.file == null) {
            this.properties = new EditableProperties(false);
            return this.properties;
        }
        EditorCookie cake = (EditorCookie)this.file.getLookup().lookup(EditorCookie.class);
        if (cake != null) {
            this.openedDocument = cake.getDocument();
        }
        if (this.openedDocument == null) {
            EditableProperties p;
            try (InputStream istm = this.file.getInputStream();){
                p = new EditableProperties(false);
                p.load(istm);
            }
            this.properties = p;
            return p;
        }
        IOException[] err = new IOException[1];
        AtomicReference ref = new AtomicReference();
        this.openedDocument.render(() -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (PrintWriter pw = new PrintWriter(baos);){
                pw.print(this.openedDocument.getText(0, this.openedDocument.getLength()));
                ref.set(new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (BadLocationException ex) {
                err[0] = new IOException(ex);
            }
        });
        EditableProperties p = new EditableProperties(false);
        p.load((InputStream)ref.get());
        this.properties = p;
        return p;
    }

    public void save() throws IOException {
        if (this.file != null) {
            EditorCookie cake = (EditorCookie)this.file.getLookup().lookup(EditorCookie.class);
            if (cake != null) {
                this.openedDocument = cake.getDocument();
            }
            if (this.openedDocument != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.properties.store((OutputStream)baos);
                String str = new String(baos.toByteArray(), StandardCharsets.ISO_8859_1);
                AtomicLockDocument ald = (AtomicLockDocument)LineDocumentUtils.asRequired((Document)this.openedDocument, AtomicLockDocument.class);
                BadLocationException[] err = new BadLocationException[1];
                Runnable edit = () -> {
                    int curLen = this.openedDocument.getLength();
                    try {
                        this.openedDocument.insertString(0, str, null);
                        this.openedDocument.remove(str.length(), curLen);
                    }
                    catch (BadLocationException ex) {
                        err[0] = ex;
                    }
                };
                ald.runAtomicAsUser(edit);
                ((Savable)this.file.getLookup().lookup(Savable.class)).save();
                return;
            }
        }
        try (OutputStream fos = Files.newOutputStream(this.filePath, StandardOpenOption.CREATE_NEW, StandardOpenOption.TRUNCATE_EXISTING);){
            this.properties.store(fos);
        }
    }
}

