/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.graalvm.visualizer.filter.DiagramFilters;
import org.graalvm.visualizer.shell.actions.Bundle;
import org.graalvm.visualizer.shell.actions.ViewerToolbarAction;
import org.graalvm.visualizer.view.api.DiagramEvent;
import org.graalvm.visualizer.view.api.DiagramListener;
import org.graalvm.visualizer.view.api.DiagramModel;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.ActionPresenterProvider;
import org.openide.util.actions.Presenter;

public class ResetDiagramToolbarAction
extends ViewerToolbarAction
implements ContextAwareAction,
Presenter.Toolbar,
Presenter.Popup,
DiagramListener {
    private final DiagramModel model;
    private final DiagramFilters filters;

    public ResetDiagramToolbarAction() {
        this((Lookup)null);
    }

    @Override
    public String getName() {
        return "reset-custom-script";
    }

    @Override
    protected String iconResource() {
        return "org/graalvm/visualizer/shell/resources/reset.png";
    }

    private ResetDiagramToolbarAction(Lookup lkp) {
        this.model = lkp != null ? (DiagramModel)lkp.lookup(DiagramModel.class) : null;
        if (this.model != null) {
            this.filters = (DiagramFilters)this.model.getLookup().lookup(DiagramFilters.class);
            this.model.addDiagramListener((DiagramListener)WeakListeners.create(DiagramListener.class, (EventListener)this, (Object)this.model));
        } else {
            this.filters = null;
        }
        this.putValue("ShortDescription", Bundle.ACTION_ResetCustomScript());
        this.computeEnabled();
    }

    private void computeEnabled() {
        this.setEnabled(this.filters != null && !this.filters.getScriptFilters().isEmpty());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ResetDiagramToolbarAction(actionContext);
    }

    public void stateChanged(DiagramEvent ev) {
        this.refresh();
    }

    public void diagramChanged(DiagramEvent ev) {
        this.refresh();
    }

    public void diagramReady(DiagramEvent ev) {
    }

    public void refresh() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.computeEnabled();
        } else {
            SwingUtilities.invokeLater(this::computeEnabled);
        }
    }

    public Component getToolbarPresenter() {
        return ActionPresenterProvider.getDefault().createToolbarPresenter((Action)this);
    }

    public JMenuItem getPopupPresenter() {
        return ActionPresenterProvider.getDefault().createPopupPresenter((Action)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.filters == null) {
            return;
        }
        this.filters.applyScriptFilter(null, null, false, null);
    }
}

