/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell.impl;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.FilterCanceledException;
import org.graalvm.visualizer.filter.FilterEvent;
import org.graalvm.visualizer.filter.FilterExecution;
import org.graalvm.visualizer.filter.FilterListener;
import org.graalvm.visualizer.shell.ShellUtils;
import org.graalvm.visualizer.shell.impl.Bundle;
import org.graalvm.visualizer.shell.impl.FileChainProvider;
import org.netbeans.api.io.Hyperlink;
import org.netbeans.api.io.InputOutput;
import org.netbeans.api.io.OutputColor;
import org.netbeans.api.io.OutputWriter;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.openide.util.Exceptions;

class ExecutionErrorReporter
implements FilterListener {
    private static ExecutionErrorReporter INSTANCE;
    private static final String[] FILE_PATTERNS;

    ExecutionErrorReporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init() {
        Class<ExecutionErrorReporter> clazz = ExecutionErrorReporter.class;
        synchronized (ExecutionErrorReporter.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            INSTANCE = new ExecutionErrorReporter();
            // ** MonitorExit[var0] (shouldn't be in output)
            FilterExecution.getExecutionService().addFilterListener((FilterListener)INSTANCE);
            return;
        }
    }

    public void filterStart(FilterEvent e) {
    }

    public void filterEnd(FilterEvent e) {
        Throwable c;
        Throwable err = e.getExecutionError();
        if (err == null || err instanceof FilterCanceledException) {
            return;
        }
        Filter errFilter = e.getFilter();
        FileObject file = ShellUtils.lookupFilterFile(errFilter.getLookup());
        if (file == null) {
            return;
        }
        InputOutput io = FileChainProvider.getScriptingIO();
        String msg = err.getMessage();
        boolean printed = false;
        if (err instanceof RuntimeException && (c = err.getCause()) instanceof ScriptException) {
            ScriptException sc = (ScriptException)c;
            msg = sc.getMessage();
            Throwable p = c.getCause();
            if (p != null && p != c) {
                msg = p.getMessage();
            }
            printed = ExecutionErrorReporter.prettyPrintScriptException(io, sc, msg, file);
        }
        if (msg == null) {
            return;
        }
        if (!printed) {
            io.getErr().println(msg);
        }
        io.show();
    }

    private static String findPrettyFileName(FileObject f) {
        FileObject scriptRoot;
        try {
            scriptRoot = ShellUtils.getScriptRoot();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return f.getPath();
        }
        String relPath = FileUtil.getRelativePath((FileObject)scriptRoot, (FileObject)f);
        if (relPath == null) {
            return f.getPath();
        }
        return Bundle.FILE_ScriptFile(relPath);
    }

    private static boolean prettyPrintScriptException(InputOutput io, ScriptException ex, String msg, FileObject f) {
        String fn = ex.getFileName();
        if (fn == null) {
            return false;
        }
        int fi = msg.indexOf(fn);
        if (fi == -1) {
            return false;
        }
        int nl = msg.indexOf(10);
        if (nl == -1) {
            nl = msg.length() - 1;
        }
        String line = msg.substring(0, nl + 1);
        int s = -1;
        int e = -1;
        Matcher m = null;
        for (String format : FILE_PATTERNS) {
            Pattern p = Pattern.compile(MessageFormat.format(format, Pattern.quote(fn), ex.getLineNumber(), ex.getColumnNumber()), 2);
            m = p.matcher(line);
            if (!m.find()) continue;
            s = m.start();
            e = m.end();
            break;
        }
        if (m == null || s == -1) {
            return false;
        }
        int fs = m.start(1);
        int fe = m.end(1);
        OutputWriter ow = io.getErr();
        if (fs > 0) {
            ow.print(line.substring(0, s), OutputColor.failure());
        }
        GotoScriptFile r = new GotoScriptFile(f, ex.getLineNumber() - 1, ex.getColumnNumber() - 1);
        ow.print(ExecutionErrorReporter.findPrettyFileName(f) + line.substring(fe, e), Hyperlink.from((Runnable)r, (boolean)true), null);
        if (e < line.length()) {
            ow.print(line.substring(e), OutputColor.failure());
        }
        if (nl < msg.length()) {
            ow.print(msg.substring(nl));
        }
        return true;
    }

    public void executionStart(FilterEvent e) {
    }

    public void executionEnd(FilterEvent e) {
    }

    static {
        FILE_PATTERNS = new String[]{"^({0}):{1}:{2}:?", "^({0}).*\\[{1}[,:]{2}\\]:?"};
    }

    private static class GotoScriptFile
    implements Runnable {
        private final FileObject file;
        private final int line;
        private final int column;

        GotoScriptFile(FileObject f, int line, int col) {
            this.file = f;
            this.line = line;
            this.column = col;
        }

        @Override
        public void run() {
            LineCookie cake = (LineCookie)this.file.getLookup().lookup(LineCookie.class);
            Line lineInstance = cake.getLineSet().getOriginal(this.line);
            if (lineInstance != null) {
                lineInstance.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, this.column);
            }
        }
    }
}

