/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.graalvm.visualizer.filter.CustomFilter;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.FilterProvider;
import org.graalvm.visualizer.script.ScriptDefinition;
import org.graalvm.visualizer.shell.impl.Bundle;
import org.graalvm.visualizer.shell.impl.ExecutionErrorReporter;
import org.netbeans.api.io.InputOutput;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;

final class FileChainProvider
implements FilterProvider {
    private final FileObject f;
    private CustomFilter editedFilter;
    private boolean editedInvalid;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private FileChangeListener fCh = new FileChangeAdapter(){

        public void fileDeleted(FileEvent fe) {
            FileChainProvider.this.createFilter(true);
        }

        public void fileChanged(FileEvent fe) {
            FileChainProvider.this.createFilter(false);
        }
    };

    public FileChainProvider(FileObject f) {
        assert (f.isData());
        this.f = f;
        this.file().addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.fCh, (Object)f));
    }

    public FileObject getFile() {
        return this.f;
    }

    private FileObject file() {
        FileObject e = (FileObject)this.f.getLookup().lookup(FileObject.class);
        return e != null ? e : this.f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter getFilter() {
        FileChainProvider fileChainProvider = this;
        synchronized (fileChainProvider) {
            if (this.editedFilter != null) {
                return this.editedFilter;
            }
        }
        return this.createFilter(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter createFilter(boolean createNew) {
        CustomFilter existingFilter;
        Object fdoc;
        EditorCookie cake = (EditorCookie)this.f.getLookup().lookup(EditorCookie.class);
        StyledDocument doc = null;
        String filterText = null;
        FileObject target = this.file();
        if (cake != null) {
            doc = cake.getDocument();
        }
        if (doc != null) {
            AtomicReference<String> res = new AtomicReference<String>("");
            fdoc = doc;
            doc.render(() -> FileChainProvider.lambda$createFilter$1(cake, (Document)fdoc, res));
            filterText = res.get();
        } else if (!target.isValid()) {
            if (!createNew) {
                return null;
            }
        } else {
            try {
                filterText = target.asText();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
        fdoc = this;
        synchronized (fdoc) {
            existingFilter = this.editedFilter;
            if (this.editedInvalid) {
                return this.editedFilter;
            }
        }
        if (filterText != null && this.f.isValid()) {
            if (existingFilter != null && !createNew) {
                existingFilter.setCode(filterText);
                return existingFilter;
            }
        } else if (existingFilter != null) {
            existingFilter.setCode("");
        }
        InstanceContent ic = new InstanceContent();
        ShellCustomFilter cf = new ShellCustomFilter(this.f.getName(), filterText, target.getMIMEType(), (Lookup)new ProxyLookup(new Lookup[]{this.f.getLookup(), new AbstractLookup((AbstractLookup.Content)ic)}));
        ic.add((Object)cf);
        FileChainProvider fileChainProvider = this;
        synchronized (fileChainProvider) {
            if (this.editedFilter == null || !this.f.isValid()) {
                this.editedFilter = cf;
                this.editedInvalid = !this.f.isValid();
            }
        }
        if (cf != existingFilter) {
            this.fireChange();
        }
        return cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireChange() {
        ChangeListener[] ll;
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                return;
            }
            ll = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : ll) {
            l.stateChanged(e);
        }
    }

    static InputOutput getScriptingIO() {
        return InputOutput.get((String)Bundle.TITLE_ShellOutputName(), (boolean)false);
    }

    private static /* synthetic */ void lambda$createFilter$1(EditorCookie cake, Document fdoc, AtomicReference res) {
        try {
            AtomicReference text = new AtomicReference();
            Runnable r = () -> {
                JEditorPane[] panes = cake.getOpenedPanes();
                String t = "";
                if (panes != null) {
                    t = panes[0].getSelectedText();
                }
                if (t == null) {
                    try {
                        t = fdoc.getText(0, fdoc.getLength());
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                res.set(t);
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (InterruptedException | InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static class ShellCustomFilter
    extends CustomFilter {
        public ShellCustomFilter(String name, String code, String mimeType, Lookup lkp) {
            super(name, code, mimeType, lkp);
        }

        protected ScriptDefinition customizeScriptDefinition(ScriptDefinition base, boolean userCode) {
            if (!userCode) {
                return base;
            }
            InputOutput io = FileChainProvider.getScriptingIO();
            base.error((PrintWriter)new OpenIOPrintWriter(io, (Writer)io.getErr()));
            base.output((PrintWriter)new OpenIOPrintWriter(io, (Writer)io.getOut()));
            ExecutionErrorReporter.init();
            return base;
        }
    }

    static class OpenIOPrintWriter
    extends PrintWriter {
        private final InputOutput io;
        private boolean opened;

        public OpenIOPrintWriter(InputOutput io, Writer out) {
            super(out);
            this.io = io;
        }

        private void ensureOpen() {
            if (this.opened) {
                return;
            }
            this.io.show();
            this.opened = true;
        }

        @Override
        public void write(String s, int off, int len) {
            if (len > 0) {
                this.ensureOpen();
            }
            super.write(s, off, len);
        }

        @Override
        public void write(char[] buf, int off, int len) {
            if (len > 0) {
                this.ensureOpen();
            }
            super.write(buf, off, len);
        }

        @Override
        public void write(int c) {
            this.ensureOpen();
            super.write(c);
        }
    }
}

