/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell.list;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.swing.Action;
import org.graalvm.visualizer.shell.ShellUtils;
import org.graalvm.visualizer.shell.list.NewScriptAction;
import org.graalvm.visualizer.shell.list.ScriptNode;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.BaseUtilities;

public class ScriptFolderNode
extends FilterNode {
    private static final Node[] NONE = new Node[0];

    public ScriptFolderNode(Node original) {
        super(original, (Children)new Ch(original));
        this.disableDelegation(384);
    }

    public Action[] getActions(boolean context) {
        FileObject f = (FileObject)this.getOriginal().getLookup().lookup(FileObject.class);
        Action[] acts = this.getOriginal().getActions(context);
        ArrayList<Action> res = new ArrayList<Action>(acts.length);
        boolean newFileAction = false;
        for (Action a : acts) {
            if (a != null && a.getClass().getName().contains(".New")) {
                if (newFileAction) continue;
                newFileAction = true;
                res.add(new NewScriptAction(f));
                continue;
            }
            res.add(a);
        }
        return res.toArray(new Action[res.size()]);
    }

    static class Ch
    extends FilterNode.Children {
        private final Node original;

        public Ch(Node or) {
            super(or);
            this.original = or;
        }

        protected Node[] createNodes(Node key) {
            FileObject f = (FileObject)key.getLookup().lookup(FileObject.class);
            if (f == null || ShellUtils.visibleScriptObjects().test(f)) {
                return super.createNodes(key);
            }
            ShellUtils.onScrapMaterialize(f, new RefCh(this, f));
            return NONE;
        }

        private void refreshNodes() {
            this.setKeys(this.original.getChildren().getNodes(true));
        }

        protected Node copyNode(Node node) {
            FileObject f = (FileObject)node.getLookup().lookup(FileObject.class);
            if (f == null) {
                return super.copyNode(node);
            }
            if (f.isFolder()) {
                return new ScriptFolderNode(node);
            }
            return ScriptNode.create(node, LEAF);
        }
    }

    private static class RefCh
    extends WeakReference<Ch>
    implements Runnable,
    Consumer<FileObject> {
        private final Reference<FileObject> refFile;

        public RefCh(Ch referent, FileObject file) {
            super(referent, BaseUtilities.activeReferenceQueue());
            this.refFile = new WeakReference<FileObject>(file);
        }

        @Override
        public void run() {
            FileObject f = this.refFile.get();
            if (f != null) {
                ShellUtils.removeMaterializeCallback(f, this);
            }
        }

        @Override
        public void accept(FileObject t) {
            Ch ch = (Ch)((Object)this.get());
            if (ch != null) {
                ch.refreshNodes();
            }
        }
    }
}

