/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.project;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.openjdk.project.JDKProject;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class SourcesImpl
implements Sources,
FileChangeListener,
ChangeListener {
    public static final String SOURCES_TYPE_JDK_PROJECT = "jdk-project-sources";
    public static final String SOURCES_TYPE_JDK_PROJECT_TESTS = "jdk-project-sources-tests";
    public static final String SOURCES_TYPE_JDK_PROJECT_NATIVE = "jdk-project-sources-native";
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final JDKProject project;
    private final Map<JDKProject.Root, SourceGroup> root2SourceGroup = new HashMap<JDKProject.Root, SourceGroup>();
    private final Map<String, List<SourceGroup>> key2SourceGroups = new HashMap<String, List<SourceGroup>>();
    private final Set<File> seen = new HashSet<File>();
    private int changeCount = 0;
    private int changeCountForCurrentValues = -1;

    public SourcesImpl(JDKProject project) {
        this.project = project;
        for (JDKProject.Root r : project.getRoots()) {
            r.addChangeListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceGroup[] getSourceGroups(String type) {
        while (true) {
            HashMap<JDKProject.Root, SourceGroup> root2SourceGroupsCopy;
            int currentChangeCount;
            SourcesImpl sourcesImpl = this;
            synchronized (sourcesImpl) {
                currentChangeCount = this.changeCount;
                if (this.changeCountForCurrentValues == currentChangeCount) {
                    return (SourceGroup[])this.key2SourceGroups.getOrDefault(type, List.of()).toArray(SourceGroup[]::new);
                }
                root2SourceGroupsCopy = new HashMap<JDKProject.Root, SourceGroup>(this.root2SourceGroup);
            }
            RecomputeResult recomputed = SourcesImpl.recompute(this.project, root2SourceGroupsCopy);
            SourcesImpl sourcesImpl2 = this;
            synchronized (sourcesImpl2) {
                if (currentChangeCount == this.changeCount) {
                    this.root2SourceGroup.clear();
                    this.root2SourceGroup.putAll(recomputed.root2SourceGroup());
                    this.key2SourceGroups.clear();
                    this.key2SourceGroups.putAll(recomputed.key2SourceGroups());
                    HashSet<File> added = new HashSet<File>(recomputed.seen());
                    added.removeAll(this.seen);
                    HashSet<File> removed = new HashSet<File>(this.seen);
                    removed.removeAll(recomputed.seen());
                    for (File a : added) {
                        FileUtil.addFileChangeListener((FileChangeListener)this, (File)a);
                        this.seen.add(a);
                        FileOwnerQuery.markExternalOwner((URI)Utilities.toURI((File)a), null, (int)0);
                        FileOwnerQuery.markExternalOwner((URI)Utilities.toURI((File)a), (Project)this.project, (int)0);
                    }
                    for (File r : removed) {
                        FileUtil.removeFileChangeListener((FileChangeListener)this, (File)r);
                        this.seen.remove(r);
                        FileOwnerQuery.markExternalOwner((URI)Utilities.toURI((File)r), null, (int)0);
                    }
                    this.changeCountForCurrentValues = currentChangeCount;
                    return (SourceGroup[])this.key2SourceGroups.getOrDefault(type, List.of()).toArray(SourceGroup[]::new);
                }
            }
        }
    }

    private static RecomputeResult recompute(JDKProject project, Map<JDKProject.Root, SourceGroup> root2SourceGroup) {
        HashMap<String, List<SourceGroup>> key2SourceGroups = new HashMap<String, List<SourceGroup>>();
        HashSet<File> seen = new HashSet<File>();
        for (SourceGroup sg : GenericSources.genericOnly((Project)project).getSourceGroups("generic")) {
            SourcesImpl.addSourceGroup(key2SourceGroups, "generic", sg);
        }
        for (JDKProject.Root root : project.getRoots()) {
            FileObject src;
            URL srcURL = root.getLocation();
            if ("file".equals(srcURL.getProtocol())) {
                try {
                    seen.add(Utilities.toFile((URI)srcURL.toURI()));
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if ((src = URLMapper.findFileObject((URL)srcURL)) == null) continue;
            SourceGroup sg = root2SourceGroup.get(root);
            if (sg == null) {
                sg = new SourceGroupImpl(GenericSources.group((Project)project, (FileObject)src, (String)root.displayName, (String)root.displayName, null, null), root.includes, root.excludes);
                root2SourceGroup.put(root, sg);
            }
            if (root.kind == JDKProject.RootKind.NATIVE_SOURCES) {
                SourcesImpl.addSourceGroup(key2SourceGroups, SOURCES_TYPE_JDK_PROJECT_NATIVE, sg);
            } else {
                SourcesImpl.addSourceGroup(key2SourceGroups, "java", sg);
            }
            if (root.kind == JDKProject.RootKind.TEST_SOURCES) {
                SourcesImpl.addSourceGroup(key2SourceGroups, SOURCES_TYPE_JDK_PROJECT_TESTS, sg);
            }
            SourcesImpl.addSourceGroup(key2SourceGroups, SOURCES_TYPE_JDK_PROJECT, sg);
            if (FileUtil.isParentOf((FileObject)project.getProjectDirectory(), (FileObject)src)) continue;
            SourcesImpl.addSourceGroup(key2SourceGroups, "generic", GenericSources.group((Project)project, (FileObject)src, (String)root.displayName, (String)root.displayName, null, null));
        }
        return new RecomputeResult(root2SourceGroup, key2SourceGroups, seen);
    }

    private static void addSourceGroup(Map<String, List<SourceGroup>> key2SourceGroups, String type, SourceGroup sg) {
        List<SourceGroup> groups = key2SourceGroups.get(type);
        if (groups == null) {
            groups = new ArrayList<SourceGroup>();
            key2SourceGroups.put(type, groups);
        }
        groups.add(sg);
    }

    public void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }

    public void fileFolderCreated(FileEvent fe) {
        this.changed();
    }

    public void fileDataCreated(FileEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileDeleted(FileEvent fe) {
        this.changed();
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.changed();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changed() {
        SourcesImpl sourcesImpl = this;
        synchronized (sourcesImpl) {
            ++this.changeCount;
        }
        this.cs.fireChange();
    }

    private record RecomputeResult(Map<JDKProject.Root, SourceGroup> root2SourceGroup, Map<String, List<SourceGroup>> key2SourceGroups, Set<File> seen) {
    }

    private static final class SourceGroupImpl
    implements SourceGroup {
        private final SourceGroup delegate;
        private final Pattern includes;
        private final Pattern excludes;

        public SourceGroupImpl(SourceGroup delegate, Pattern includes, Pattern excludes) {
            this.delegate = delegate;
            this.includes = includes;
            this.excludes = excludes;
        }

        public FileObject getRootFolder() {
            return this.delegate.getRootFolder();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public String getDisplayName() {
            return this.delegate.getDisplayName();
        }

        public Icon getIcon(boolean opened) {
            return this.delegate.getIcon(opened);
        }

        public boolean contains(FileObject file) {
            if (this.delegate.contains(file)) {
                if (this.includes == null && this.excludes == null) {
                    return true;
                }
                String rel = FileUtil.getRelativePath((FileObject)this.delegate.getRootFolder(), (FileObject)file);
                if (this.includes != null && !this.includes.matcher(rel).matches()) {
                    return false;
                }
                if (this.excludes == null) {
                    return true;
                }
                return !this.excludes.matcher(rel).matches();
            }
            return false;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }
}

