/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search;

import java.util.Iterator;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.search.Bundle;
import org.graalvm.visualizer.search.NodesList;
import org.graalvm.visualizer.search.NodesProvider;

public final class SimpleNodeProvider
implements NodesProvider {
    @Override
    public String getId() {
        return "igv.core.GraphNodes";
    }

    @Override
    public String getDisplayName() {
        return Bundle.NodeProvider_igv_core_GraphNodes();
    }

    @Override
    public NodesList nodes(InputGraph graph) {
        return new NodesIterator(graph);
    }

    private static class NodesIterator
    implements NodesList {
        private final InputGraph graph;
        private final Iterator<InputNode> nodes;
        private int visited;

        public NodesIterator(InputGraph graph) {
            this.graph = graph;
            this.nodes = graph.getNodes().iterator();
        }

        @Override
        public int visitedCount() {
            return this.visited;
        }

        @Override
        public int nodesCount() {
            return this.graph.getNodeCount();
        }

        @Override
        public boolean hasNext() {
            return this.nodes.hasNext();
        }

        @Override
        public InputNode next() {
            ++this.visited;
            return this.nodes.next();
        }
    }
}

