/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search.ui.actions;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.data.services.GraphViewer;
import org.graalvm.visualizer.data.services.NodeContext;
import org.graalvm.visualizer.view.api.DiagramViewer;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public abstract class GraphContextAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private static final BitSet EMPTY = new BitSet();
    private static final Map<Group, BitSet> nodeIdsCache = new WeakHashMap<Group, BitSet>();
    private final List<InputNode> inputNodes;
    private final Lookup context;
    private final Lookup.Result<InputNode> res;
    private InputGraph targetGraph;
    private Group targetGroup;

    protected GraphContextAction(List<InputNode> nodes) {
        this(nodes, Utilities.actionsGlobalContext());
    }

    protected GraphContextAction(Lookup context) {
        this(new ArrayList(context.lookupAll(InputNode.class)), context);
    }

    private GraphContextAction(List<? extends InputNode> nodes, Lookup context) {
        this.inputNodes = nodes;
        this.context = context;
        this.res = context.lookupResult(InputNode.class);
        this.res.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.res));
        this.update();
    }

    public void resultChanged(LookupEvent le) {
        if (this.changeSupport != null && this.changeSupport.getPropertyChangeListeners().length == 0) {
            return;
        }
        SwingUtilities.invokeLater(this::update);
    }

    protected List<InputNode> getInputNodes() {
        return this.inputNodes;
    }

    protected InputGraph getTargetGraph() {
        return this.targetGraph;
    }

    protected Group getTargetGroup() {
        return this.targetGroup;
    }

    protected Lookup ctx() {
        return this.context;
    }

    private void update() {
        DiagramViewer vwr = (DiagramViewer)((GraphViewer)Lookup.getDefault().lookup(GraphViewer.class)).getActiveViewer();
        InputGraph curGraph = vwr == null ? null : vwr.getGraph();
        Group pg = vwr == null ? null : vwr.getGraph().getGroup();
        BitSet nodeIds = null;
        boolean ok = true;
        boolean somePresent = false;
        InputGraph firstGraph = null;
        Group targetGroup = null;
        for (InputNode n : this.inputNodes) {
            int id = n.getId();
            NodeContext ctx = NodeContext.fromNode((InputNode)n);
            if (ctx != null) {
                if (curGraph == null) {
                    curGraph = ctx.getGraph();
                    pg = ctx.getParent().getContentOwner();
                }
                Group owner = ctx.getParent().getContentOwner();
                if (targetGroup != null && targetGroup != owner) {
                    ok = false;
                    break;
                }
                targetGroup = owner;
                if (owner != pg) continue;
                if (firstGraph == null) {
                    firstGraph = ctx.getGraph();
                }
                if (!curGraph.getNodeIds().contains(id)) continue;
                somePresent = true;
                continue;
            }
            if (pg == null) continue;
            if (nodeIds == null) {
                nodeIds = GraphContextAction.findNodeIds(pg);
            }
            if (nodeIds.get(id)) continue;
            ok = false;
            break;
        }
        if (targetGroup == null) {
            targetGroup = pg;
        }
        if (firstGraph == null) {
            firstGraph = curGraph;
        }
        if (!ok || targetGroup == null) {
            this.setEnabled(false);
            return;
        }
        this.targetGraph = !somePresent || curGraph == null ? firstGraph : curGraph;
        if (vwr == null || targetGroup != pg) {
            this.putValue("Name", this.createNameWithTarget(targetGroup, this.targetGraph));
        }
        this.targetGroup = targetGroup;
    }

    protected abstract String createNameWithTarget(Group var1, InputGraph var2);

    private static BitSet findNodeIds(Group g) {
        if (g == null) {
            return EMPTY;
        }
        BitSet bs = nodeIdsCache.get(g);
        if (bs != null) {
            return bs;
        }
        bs = new BitSet();
        for (InputGraph ig : g.getGraphs()) {
            for (Integer i : ig.getNodeIds()) {
                bs.set(i);
            }
        }
        nodeIdsCache.put(g, bs);
        return bs;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

