/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.actions;

import org.graalvm.visualizer.coordinator.actions.RemoveCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class RemoveAction
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
        for (Node n : activatedNodes) {
            RemoveCookie removeCookie = (RemoveCookie)n.getCookie(RemoveCookie.class);
            if (removeCookie == null) continue;
            removeCookie.remove();
        }
    }

    public RemoveAction() {
        this.putValue("ShortDescription", "Remove selected graphs and groups");
    }

    public String getName() {
        return NbBundle.getMessage(RemoveAction.class, (String)"CTL_RemoveAction");
    }

    protected String iconResource() {
        return "org/graalvm/visualizer/coordinator/images/remove.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodes) {
        return nodes.length > 0;
    }
}

