/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.actions;

import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.filechooser.FileFilter;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import org.graalvm.visualizer.coordinator.actions.Bundle;
import org.graalvm.visualizer.coordinator.actions.SaveActionPerformer;
import org.graalvm.visualizer.coordinator.actions.SaveOperation;
import org.graalvm.visualizer.coordinator.impl.SessionManagerImpl;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class SaveAsAction
extends NodeAction {
    public SaveAsAction() {
        this(null);
    }

    private SaveAsAction(Lookup actionContext) {
        this.putValue("ShortDescription", Bundle.MSG_SavesSelectedGroupsToFile());
    }

    protected void performAction(Node[] activatedNodes) {
        SaveOperation oper = new SaveOperation(true, Arrays.stream(activatedNodes).map(n -> (Folder)n.getLookup().lookup(Folder.class)).filter(Objects::nonNull).collect(Collectors.toList()), SessionManagerImpl.getInstance());
        new SaveActionPerformer(oper).doSave();
    }

    public static FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String fn = f.getName().toLowerCase(Locale.ENGLISH);
                return fn.endsWith(".bgv");
            }

            @Override
            public String getDescription() {
                return Bundle.MSG_BIGV_Description();
            }
        };
    }

    protected int mode() {
        return 2;
    }

    public String getName() {
        return NbBundle.getMessage(SaveAsAction.class, (String)"CTL_SaveAsAction");
    }

    protected String iconResource() {
        return "org/graalvm/visualizer/coordinator/images/save.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodes) {
        int cnt = 0;
        for (Node n : nodes) {
            cnt += n.getLookup().lookupAll(Folder.class).size();
        }
        return cnt > 0;
    }
}

