/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.impl;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import org.graalvm.visualizer.coordinator.impl.FileImporter;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class FileOpenTestSupport
implements Runnable {
    private static final String OPENFILE_PROPERTY = "igv.openfile.onstartup.and.close";
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_NO_FILE = 10;
    private static final int EXIT_DATA_ERROR = 65;

    @Override
    public void run() {
        String v = System.getProperty(OPENFILE_PROPERTY);
        if (v == null) {
            return;
        }
        int exit = this.openFile(v);
        RequestProcessor.getDefault().post(() -> {
            System.err.println("LifecycleManager did not exit in time, dumping all threads:");
            Exception td = new Exception();
            for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
                td.setStackTrace(entry.getValue());
                System.err.print(entry.getKey() + ": ");
                td.printStackTrace();
            }
            System.err.flush();
            SecurityManager smgr = System.getSecurityManager();
            if (smgr != null) {
                try {
                    Method exitMethod = smgr.getClass().getMethod("exit", Integer.TYPE);
                    exitMethod.invoke((Object)smgr, exit);
                }
                catch (ReflectiveOperationException ex) {
                    ex.printStackTrace();
                }
            } else {
                System.exit(exit);
            }
        }, 5000);
        LifecycleManager.getDefault().exit(exit);
    }

    private int openFile(String v) {
        File f = new File(v);
        FileObject fo = FileUtil.toFileObject((File)f);
        if (fo == null || !fo.isValid()) {
            System.err.println(String.format("File %s does not exist or is not readable.", f.toString()));
            return 10;
        }
        if (fo.isData()) {
            return this.openOneFile(fo);
        }
        for (FileObject ff : fo.getChildren()) {
            int res;
            if (!ff.isData() || !"bgv".equalsIgnoreCase(ff.getExt()) || (res = this.openOneFile(ff)) == 0) continue;
            return res;
        }
        return 0;
    }

    private int openOneFile(FileObject fo) {
        File f = FileUtil.toFile((FileObject)fo);
        try {
            Callable<GraphDocument> c = FileImporter.createDocumentImporter(f.toPath(), false, true, null);
            if (c == null) {
                return 10;
            }
            c.call();
            return 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 65;
        }
    }
}

