/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.refactoring.java.api.ReplaceConstructorWithBuilderRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ReplaceConstructorWithBuilderPanel
extends JPanel
implements CustomRefactoringPanel {
    private static final String DEFAULT_PREFIX = "set";
    private static final String[] columnNames = new String[]{ReplaceConstructorWithBuilderPanel.getString("LBL_BuilderParameter"), ReplaceConstructorWithBuilderPanel.getString("LBL_BuilderSetterName"), ReplaceConstructorWithBuilderPanel.getString("LBL_BuilderDefaultValue"), ReplaceConstructorWithBuilderPanel.getString("LBL_BuilderOptionalSetter")};
    private static final boolean[] columnCanEdit = new boolean[]{false, true, true, true};
    private static final Class[] columnTypes = new Class[]{String.class, String.class, String.class, Boolean.class};
    private final List<String> parameterTypes;
    private final List<Boolean> parameterTypeVars;
    private final List<String> parameterNames;
    private JLabel buildMethodName;
    private JTextField buildMethodNameField;
    private JLabel buildName;
    private JTextField nameField;
    private JScrollPane paramScrollPane;
    private JTable paramTable;
    private JTextField prefixField;
    private JLabel prefixLabel;

    public ReplaceConstructorWithBuilderPanel(final @NonNull ChangeListener parent, String initialFQN, String initialBuildMethodName, List<String> paramaterNames, List<String> parameterTypes, List<Boolean> parameterTypeVars) {
        this.initComponents();
        this.parameterTypes = parameterTypes;
        this.parameterNames = paramaterNames;
        this.prefixField.setText(DEFAULT_PREFIX);
        this.buildMethodNameField.setText(initialBuildMethodName);
        this.nameField.setText(initialFQN);
        this.nameField.setSelectionStart(0);
        this.nameField.setSelectionEnd(this.nameField.getText().length());
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                parent.stateChanged(new ChangeEvent(ReplaceConstructorWithBuilderPanel.this));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                parent.stateChanged(new ChangeEvent(ReplaceConstructorWithBuilderPanel.this));
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.buildMethodNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                parent.stateChanged(new ChangeEvent(ReplaceConstructorWithBuilderPanel.this));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                parent.stateChanged(new ChangeEvent(ReplaceConstructorWithBuilderPanel.this));
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        DefaultTableModel model = (DefaultTableModel)this.paramTable.getModel();
        Iterator<String> typesIt = parameterTypes.iterator();
        for (String name : paramaterNames) {
            model.addRow(new Object[]{typesIt.next() + " " + name, DEFAULT_PREFIX + Character.toUpperCase(name.charAt(0)) + name.substring(1), null, false});
        }
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                parent.stateChanged(new ChangeEvent(ReplaceConstructorWithBuilderPanel.this));
            }
        });
        this.prefixField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent de) {
                this.updateSetters(de);
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                this.updateSetters(de);
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                this.updateSetters(de);
            }

            private void updateSetters(DocumentEvent de) {
                try {
                    String prefix = de.getDocument().getText(0, de.getDocument().getLength());
                    ReplaceConstructorWithBuilderPanel.this.updateSetterNames(prefix);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        this.parameterTypeVars = parameterTypeVars;
    }

    private void initComponents() {
        this.buildName = new JLabel();
        this.buildMethodNameField = new JTextField();
        this.paramScrollPane = new JScrollPane();
        this.paramTable = new JTable(){

            @Override
            public boolean isCellEditable(int row, int column) {
                if (column == 2 || column == 3) {
                    return ReplaceConstructorWithBuilderPanel.this.parameterTypeVars.get(row) == false;
                }
                return super.isCellEditable(row, column);
            }
        };
        this.prefixLabel = new JLabel();
        this.prefixField = new JTextField();
        this.buildMethodName = new JLabel();
        this.nameField = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.buildName, (String)NbBundle.getMessage(ReplaceConstructorWithBuilderPanel.class, (String)"ReplaceConstructorWithBuilder.jLabel1.text"));
        this.paramTable.setModel(new DefaultTableModel(new Object[0][], columnNames){

            public Class getColumnClass(int columnIndex) {
                return columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnCanEdit[columnIndex];
            }
        });
        this.paramScrollPane.setViewportView(this.paramTable);
        Mnemonics.setLocalizedText((JLabel)this.prefixLabel, (String)NbBundle.getMessage(ReplaceConstructorWithBuilderPanel.class, (String)"ReplaceConstructorWithBuilder.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.buildMethodName, (String)NbBundle.getMessage(ReplaceConstructorWithBuilderPanel.class, (String)"ReplaceConstructorWithBuilder.jLabel3.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.paramScrollPane, -1, 561, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.prefixLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prefixField, -2, 176, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buildMethodName, -1, -1, Short.MAX_VALUE).addComponent(this.buildName, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buildMethodNameField).addComponent(this.nameField))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.prefixLabel).addComponent(this.prefixField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paramScrollPane, -2, 154, -2).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buildMethodName).addComponent(this.buildMethodNameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buildName).addComponent(this.nameField, -2, -1, -2)).addGap(3, 3, 3)));
    }

    public void initialize() {
    }

    public String getBuilderName() {
        return this.nameField.getText();
    }

    public String getBuildMethodName() {
        return this.buildMethodNameField.getText();
    }

    @Override
    public boolean requestFocusInWindow() {
        this.nameField.requestFocusInWindow();
        return true;
    }

    public List<ReplaceConstructorWithBuilderRefactoring.Setter> getSetters() {
        ArrayList<ReplaceConstructorWithBuilderRefactoring.Setter> result = new ArrayList<ReplaceConstructorWithBuilderRefactoring.Setter>();
        int size = this.parameterTypes.size();
        for (int i = 0; i < size; ++i) {
            String name = (String)((DefaultTableModel)this.paramTable.getModel()).getValueAt(i, 0);
            result.add(new ReplaceConstructorWithBuilderRefactoring.Setter((String)((DefaultTableModel)this.paramTable.getModel()).getValueAt(i, 1), this.parameterTypes.get(i), (String)((DefaultTableModel)this.paramTable.getModel()).getValueAt(i, 2), name.substring(name.lastIndexOf(32)).trim(), (Boolean)((DefaultTableModel)this.paramTable.getModel()).getValueAt(i, 3)));
        }
        return result;
    }

    public Component getComponent() {
        return this;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(ReplaceConstructorWithBuilderPanel.class, (String)key);
    }

    private void updateSetterNames(String prefix) {
        DefaultTableModel model = (DefaultTableModel)this.paramTable.getModel();
        for (int k = 0; k < this.parameterNames.size(); ++k) {
            if (prefix == null || prefix.isEmpty()) {
                model.setValueAt(this.parameterNames.get(k), k, 1);
                continue;
            }
            model.setValueAt(prefix + Character.toUpperCase(this.parameterNames.get(k).charAt(0)) + this.parameterNames.get(k).substring(1), k, 1);
        }
    }
}

