/**
This Media Source Extensions API interface represents a source of media data for an HTMLMediaElement object. A MediaSource object can be attached to a HTMLMediaElement to be played in the user agent.

@returns {MediaSource}
*/
MediaSource = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {SourceBufferList}
**/
MediaSource.prototype.activeSourceBuffers = new SourceBufferList();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
MediaSource.prototype.duration = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: MediaSource, ev: Event) => any) | null
**/
MediaSource.prototype.onsourceclose = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: MediaSource, ev: Event) => any) | null
**/
MediaSource.prototype.onsourceended = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: MediaSource, ev: Event) => any) | null
**/
MediaSource.prototype.onsourceopen = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("closed" | "ended" | "open")} ReadyState
**/
MediaSource.prototype.readyState = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {SourceBufferList}
**/
MediaSource.prototype.sourceBuffers = new SourceBufferList();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@returns {SourceBuffer}
**/
MediaSource.prototype.addSourceBuffer = function(type) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
MediaSource.prototype.clearLiveSeekableRange = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {("decode" | "network")} [error] EndOfStreamError
@returns {undefined}
**/
MediaSource.prototype.endOfStream = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {SourceBuffer} sourceBuffer SourceBuffer
@returns {undefined}
**/
MediaSource.prototype.removeSourceBuffer = function(sourceBuffer) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} start
@param {Number} end
@returns {undefined}
**/
MediaSource.prototype.setLiveSeekableRange = function(start, end) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
MediaSource.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
MediaSource.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(AddEventListenerOptions | Boolean)} [options] AddEventListenerOptions | boolean
@returns {undefined}
**/
MediaSource.prototype.addEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise.

@param {Event} event Event
@returns {Boolean}
**/
MediaSource.prototype.dispatchEvent = function(event) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(EventListenerOptions | Boolean)} [options] EventListenerOptions | boolean
@returns {undefined}
**/
MediaSource.prototype.removeEventListener = function(type, callback) {};

